<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Page_Controller extends Pf_Plugin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('page', true);
        $this->model = new Pf_Page_Model;
        $this->acl = array(1, 2);
        $this->check_acl();
    }

    public function main()
    {
        $conditions = 'page_system = 0';
        $param = array();
        $url = admin_url('admin-page=page', false);
        if ($this->input->has_get('status')) {
            $conditions .= " and page_status = ? ";
            $status = $this->input->get('status', true) == 1 ? 1 : 0;
            $param[] = $status;
            $url .= "&status={$status}";
        }
        if ($this->input->has_get('kw')) {
            $conditions .= " and page_title like ? ";
            $param[] = "%{$this->input->get('kw')}%";
            $url .= "&kw={$this->input->get('kw')}";
        }
        /* Count paging */
        $total = $this->model->conditions($conditions)->param($param)->count();
        $page = $this->input->has_get('current') ? (int) $this->input->get('current', true) - 1 : 0;
        $per_page = (int) $page * NUM_PER_PAGE;
        /* Get data */
        $condition_get = " WHERE {$conditions} ORDER BY id DESC LIMIT {$per_page}, " . NUM_PER_PAGE;
        $pages = $total > 0 ? $this->model->select('id', 'page_title', 'page_status')
                        ->conditions($condition_get)->param($param)->get() : array();
        $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'current');
        $this->data['pages'] = $pages;
        $this->data['pagination'] = $pagination;
        $this->data['url'] = $url;
        $this->view->render('main', $this->data);
    }

    /*
     * Bulk Action
     */

    public function bulk_action()
    {
        if (!$this->input->has_post('id')) {
            return false;
        }
        $action = $this->input->post('action');
        $id = $this->input->post('id');
        $condition = generate_where_in($id);
        $current = (int) $this->input->post('current');
        if ($action == 3) {
            $this->delete_pages($condition, $id);
        } else {
            $this->update_status(array('page_status' => $action), $condition, $id, $current);
        }
    }

    private function update_status($data, $condition, $param, $current = '')
    {
        $result = $this->model->conditions("id in({$condition})")
                        ->param($param)->update($data, false);
        $messages = array(
            'success' => __('Status is updated successfully', 'page'),
            'danger' => __('An error has occurred. Please try again', 'page')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act=&status=&token&current={$current}");
    }

    private function delete_pages($condition, $param)
    {
        $result = $this->model->conditions("id in($condition)")->param($param)->delete();
        $messages = array(
            'success' => __('Page is deleted successfully', 'page'),
            'danger' => __('An error has occurred. Please try again', 'page')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act=main&current");
    }

    /*
     * Create Page
     */

    public function create()
    {
        if ($this->input->has_post('title')) {
            $data = $this->model->get_data_input(array(
                'input-clone'
            ));
            $id = $this->model->insert($data);
            if ($id > 0) {
                $this->session->flash('success', __('You have successfully created page new', 'page'));
                Pf_Plugin_Redirect::to('&act=edit&id=' . $id);
            } else {
                $error = $this->model->get_errors();
                $this->data['error'] = !empty($error) ? __('Please check the data field!', 'page') : __('An error has occurred. Please try again', 'page');
                $this->data['validated'] = $this->model->get_errors();
            }
        }
        $this->data['status'] = $this->model->get_status_pages();
        $this->data['layouts'] = $this->model->get_layout_pages();
        $this->data['slider'] = $this->model->get_sliders();
        $this->data['page_type'] = $this->model->get_page_type();
        $this->view->render('create', $this->data);
    }

    /*
     * Update Page
     */

    public function edit()
    {
        if ($this->input->has_get('id')) {
            $id = (int) $this->input->get('id', true);
            $page = $this->model->find($id, 'id,page_title,page_content,page_url,page_layout,page_type,page_author,page_meta_title,page_meta_keywords,page_meta_description,page_system,page_status');
            count($page) || Pf_Plugin_Redirect::to('&act=&id=');
        }
        if ($this->input->has_post('page_id')) {
            $data = $this->model->get_data_input(array(
                'input-clone',
                'page_id',
                'current'
            ));
            if ($this->model->conditions('id = ?')->param($id)->update($data)) {
                if ($this->input->post('url') === $page->page_url) {
                    upate_widget_category();
                }
                $this->session->flash('success', __('You have successfully updated page', 'page'));
                Pf_Plugin_Redirect::to('&act=edit&id=' . $id);
            } else {
                $error = $this->model->get_errors();
                $this->data['error'] = !empty($error) ? __('Please check the data field!', 'page') : __('An error has occurred. Please try again', 'page');
                $this->data['validated'] = $error;
            }
        }
        $data = array(
            'status' => $this->model->get_status_pages(),
            'layouts' => $this->model->get_layout_pages(),
            'slider' => $this->model->get_sliders(),
            'page_type' => $this->model->get_page_type(),
            'page' => $page
        );
        $this->data = array_merge($this->data, $data);
        $this->view->render('edit', $this->data);
    }

    /*
     * Delete Page
     */

    public function delete()
    {
        if ($this->input->has_get('id')) {
            $id = $this->input->get('id', true);
            $result = $this->model->conditions("id = ?")->param($id)->delete();
            $messages = array(
                'success' => __('Page is deleted successfully', 'page'),
                'danger' => __('An error has occurred. Please try again', 'page')
            );
            $this->alertSave($messages, $result);
        }
        Pf_Plugin_Redirect::to('&act=main&id&token');
    }

    /*
     * Ajax
     */

    public function ajax_check_exists_slug()
    {
        if (!is_ajax()) {
            return;
        }
        $conditions = " 1 ";
        $param = array();
        if ($this->input->has_post('slug')) {
            $conditions .= " and page_url = ? ";
            $param[] = $this->input->post('slug');
        }
        if ($this->input->has_post('id')) {
            $conditions .= " and id != ? ";
            $param[] = $this->input->post('id');
        }
        $result = $this->model->conditions($conditions)->param($param)->count();
        echo $result;
    }

    /*
     * Status
     */

    public function status()
    {
        $curent = $this->input->get('current');
        if ($this->input->has_get('id') && $this->input->has_get('type')) {
            $id = $this->input->get('id');
            $status = $this->input->get('type') == 2 ? 0 : 1;
            if ($this->model->set_rules(array())->conditions(' id = ?')
                            ->param($id)->update(array('page_status' => $status))) {
                $this->session->flash('success', __('Status is updated successfully', 'page'));
            } else {
                $this->session->flash('danger', __('An error has occurred. Please try again', 'page'));
            }
        }
        Pf_Plugin_Redirect::to('&act&id&type&current=' . $curent);
    }

}
